/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core;

import com.aptana.core.util.PlatformUtil;
import com.aptana.js.debug.core.ILaunchConfigurationConstants;
import com.aptana.js.debug.core.internal.browsers.BrowserUtil;
import com.aptana.js.debug.core.internal.browsers.Firefox;
import com.aptana.js.debug.core.internal.browsers.InternetExplorer;
import java.io.File;
import java.util.Enumeration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSLaunchConfigurationHelper {
    public static final String FIREFOX = "Firefox";
    public static final String INTERNET_EXPLORER = "Internet Explorer";
    public static final String SAFARI = "Safari";

    private JSLaunchConfigurationHelper() {
    }

    public static void setDefaults(ILaunchConfigurationWorkingCopy configuration, String nature) {
        JSLaunchConfigurationHelper.setBrowserDefaults(configuration, nature);
        JSLaunchConfigurationHelper.setServerDefaults(configuration);
        JSLaunchConfigurationHelper.setHttpDefaults(configuration);
        JSLaunchConfigurationHelper.setDebugDefaults(configuration);
        JSLaunchConfigurationHelper.setAdvancedDefaults(configuration);
    }

    public static void setBrowserDefaults(ILaunchConfigurationWorkingCopy configuration, String nature) {
        String browser;
        block19: {
            Enumeration enumeration;
            block20: {
                File file;
                String location;
                int n;
                int n2;
                String[] stringArray;
                block21: {
                    String path;
                    block22: {
                        block17: {
                            block18: {
                                browser = "";
                                if (nature == null) {
                                    try {
                                        nature = configuration.getAttribute("browserNature", null);
                                    }
                                    catch (CoreException coreException) {
                                        // empty catch block
                                    }
                                }
                                if (!"win32".equals(Platform.getOS())) break block17;
                                if (!FIREFOX.equals(nature) && nature != null) break block18;
                                stringArray = ILaunchConfigurationConstants.DEFAULT_BROWSER_WINDOWS_FIREFOX;
                                n2 = ILaunchConfigurationConstants.DEFAULT_BROWSER_WINDOWS_FIREFOX.length;
                                n = 0;
                                while (n < n2) {
                                    location = stringArray[n];
                                    file = new File(location = PlatformUtil.expandEnvironmentStrings((String)location));
                                    if (file.exists() && !file.isDirectory()) {
                                        browser = location;
                                        break;
                                    }
                                    ++n;
                                }
                                if (browser.length() != 0) break block19;
                            }
                            if (!INTERNET_EXPLORER.equals(nature) && nature != null || !new File(path = PlatformUtil.expandEnvironmentStrings((String)"%ProgramFiles%\\Internet Explorer\\iexplore.exe")).exists()) break block20;
                            browser = path;
                            break block19;
                        }
                        if (!"macosx".equals(Platform.getOS())) break block21;
                        if (!FIREFOX.equals(nature) && nature != null) break block22;
                        stringArray = ILaunchConfigurationConstants.DEFAULT_BROWSER_MACOSX_FIREFOX;
                        n2 = ILaunchConfigurationConstants.DEFAULT_BROWSER_MACOSX_FIREFOX.length;
                        n = 0;
                        while (n < n2) {
                            location = stringArray[n];
                            file = new File(location = PlatformUtil.expandEnvironmentStrings((String)location));
                            if (file.exists() && file.isDirectory()) {
                                browser = location;
                                break;
                            }
                            ++n;
                        }
                        if (browser.length() != 0) break block19;
                    }
                    if (!SAFARI.equals(nature) && nature != null || !new File(path = "/Applications/Safari.app").exists()) break block20;
                    browser = path;
                    break block19;
                }
                if (!"linux".equals(Platform.getOS()) || !FIREFOX.equals(nature) && nature != null) break block20;
                stringArray = ILaunchConfigurationConstants.DEFAULT_BROWSER_LINUX_FIREFOX;
                n2 = ILaunchConfigurationConstants.DEFAULT_BROWSER_LINUX_FIREFOX.length;
                n = 0;
                while (n < n2) {
                    location = stringArray[n];
                    file = new File(location = PlatformUtil.expandEnvironmentStrings((String)location));
                    if (file.exists() && file.isFile()) {
                        browser = location;
                        break;
                    }
                    ++n;
                }
                if (browser.length() != 0) break block19;
            }
            if ((enumeration = (Enumeration)new JSLaunchConfigurationHelper().getContributedAdapter(Enumeration.class)) != null) {
                while (enumeration.hasMoreElements()) {
                    String path = (String)enumeration.nextElement();
                    if ((FIREFOX.equals(nature) || nature == null) && Firefox.isBrowserExecutable(path)) {
                        browser = path;
                        break;
                    }
                    if ((INTERNET_EXPLORER.equals(nature) || nature == null) && InternetExplorer.isBrowserExecutable(path)) {
                        browser = path;
                        break;
                    }
                    if (!SAFARI.equals(nature) && nature != null || path.toLowerCase().indexOf("safari") == -1) continue;
                    browser = path;
                    break;
                }
            }
        }
        configuration.setAttribute("browserExecutable", browser);
        if (nature != null) {
            configuration.setAttribute("browserNature", nature);
        }
    }

    public static void setServerDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("startActionType", 1);
        configuration.setAttribute("serverType", 1);
        configuration.setAttribute("startPagePath", "");
        configuration.setAttribute("startPageUrl", "");
        configuration.setAttribute("externalBaseUrl", "");
        configuration.setAttribute("appendProjectName", true);
    }

    public static void setDebugDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IScopeContext[] scopes = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        configuration.setAttribute("overrideDebugPreferences", false);
        configuration.setAttribute("suspendOnFirstLine", Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_first_line", false, scopes));
        configuration.setAttribute("suspendOnExceptions", Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_exceptions", false, scopes));
        configuration.setAttribute("suspendOnErrors", Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_errors", false, scopes));
        configuration.setAttribute("suspendOnDebuggerKeywords", Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_debugger_keyword", false, scopes));
    }

    public static void setAdvancedDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("advancedRunEnabled", false);
    }

    public static void setHttpDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("httpGetData", "");
        configuration.setAttribute("httpPostData", "");
        configuration.setAttribute("httpPostContentType", "");
    }

    public static boolean isBrowserDebugCompatible(String browser) {
        if (browser != null && BrowserUtil.isBrowserDebugCompatible(browser)) {
            return new File(browser).exists();
        }
        return false;
    }

    private static Object getContributedAdapter(Object object, Class<?> clazz) {
        Object adapter = null;
        IAdapterManager manager = Platform.getAdapterManager();
        if (manager.hasAdapter(object, clazz.getName()) && (adapter = manager.getAdapter(object, clazz.getName())) == null) {
            adapter = manager.loadAdapter(object, clazz.getName());
        }
        return adapter;
    }

    private Object getContributedAdapter(Class<?> clazz) {
        return JSLaunchConfigurationHelper.getContributedAdapter(this, clazz);
    }

    public static void initializeLaunchAttributes(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        if (configuration.getAttribute("overrideDebugPreferences", false)) {
            launch.setAttribute("suspendOnFirstLine", Boolean.toString(configuration.getAttribute("suspendOnFirstLine", false)));
            launch.setAttribute("suspendOnExceptions", Boolean.toString(configuration.getAttribute("suspendOnExceptions", false)));
            launch.setAttribute("suspendOnErrors", Boolean.toString(configuration.getAttribute("suspendOnErrors", false)));
            launch.setAttribute("suspendOnDebuggerKeywords", Boolean.toString(configuration.getAttribute("suspendOnDebuggerKeywords", false)));
        } else {
            IScopeContext[] scopes = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
            launch.setAttribute("suspendOnFirstLine", Boolean.toString(Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_first_line", false, scopes)));
            launch.setAttribute("suspendOnExceptions", Boolean.toString(Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_exceptions", false, scopes)));
            launch.setAttribute("suspendOnErrors", Boolean.toString(Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_errors", false, scopes)));
            launch.setAttribute("suspendOnDebuggerKeywords", Boolean.toString(Platform.getPreferencesService().getBoolean("com.aptana.js.debug.core", "com.aptana.js.debug.core.suspend_on_debugger_keyword", false, scopes)));
        }
    }
}

